# Plateau in Monotonic Linear Interpolation --- A "Biased" View of Loss Landscape for Deep Networks

This repository contains the code for running and visualizing the experiments in our paper. We made minor changes upon the code from [Analyzing Monotonic Linear Interpolation in Neural Network Loss Landscapes](https://github.com/AtheMathmo/mli-release). We refer to their repo for the installation. 

## Running Training Scripts

The training scripts utilize [sacred](https://github.com/IDSIA/sacred) for config management. An example syntax for passing config arguments is as follows:

```
python scripts/train_cifar/train.py with epochs=100 dset_name=cifar100 model_name=vgg16-nobn bias=all_bias init_scale=1 special_bias_interp=False version=1
```

We can set the bias parameter as all_bias, last_bias or no_bias. The init_scale parameter controls the weight initialization scale. Setting special_bias_interp as True will apply the homogeneous interpolation on the bias. 

#### Supported tasks

- Fully-connected network classification on MNIST/FashionMNIST
    - `python scripts/train_fcnet/train.py`
- Convolutional network classification on CIFAR-10 & CIFAR-100
    - `python scripts/train_cifar/train.py`

## Running Evaluation Scripts

After executing the training script, it will create a folder named `/runs`. It then contains a .json file that contains the information to generate the plots. We include our plotting scripts in the notebook. 
